//+------------------------------------------------------------------
//|
//+------------------------------------------------------------------
#property  copyright "www.forex-tsd.com"
#property  link      "www.forex-tsd.com"

#property indicator_chart_window
#property indicator_buffers 4
#property indicator_color1 DeepSkyBlue
#property indicator_color2 PaleVioletRed
#property indicator_color3 DeepSkyBlue
#property indicator_color4 PaleVioletRed
#property indicator_width1 2
#property indicator_width2 2
#property indicator_width3 1
#property indicator_width4 1

//
//
//
//
//

extern string TimeFrame       = "Current time frame";
extern int    FastMaPeriod    = 10;
extern int    FastMaMode      = MODE_LWMA;
extern int    FastMaPrice     = PRICE_CLOSE;
extern int    SlowMaPeriod    = 15;
extern int    SlowMaMode      = MODE_LWMA;
extern int    SlowMaPrice     = PRICE_OPEN;

extern bool   alertsOn        = true;
extern bool   alertsOnCurrent = true;
extern bool   alertsMessage   = false;
extern bool   alertsSound     = true;
extern bool   alertsEmail     = false;
extern bool   alertsNotify    = false;

//
//
//
//
//

double FastMa[];
double SlowMa[];
double CrossUp[];
double CrossDn[];
double trend[];
string indicatorFileName;
bool   returnBars;
int    timeFrame;

//+------------------------------------------------------------------
//|
//+------------------------------------------------------------------
//
//
//
//
//

int init()
{
   IndicatorBuffers(5);
      SetIndexBuffer(0,FastMa);
      SetIndexBuffer(1,SlowMa);
      SetIndexBuffer(2,CrossUp); SetIndexStyle( 2,DRAW_ARROW); SetIndexArrow( 2, 233 );
      SetIndexBuffer(3,CrossDn); SetIndexStyle( 3,DRAW_ARROW); SetIndexArrow( 3, 234 );
      SetIndexBuffer(4,trend);
      
      //
      //
      //
      //
      //
      
         indicatorFileName = WindowExpertName();
         returnBars        = (TimeFrame=="returnBars"); if (returnBars) return(0);
         timeFrame         = stringToTimeFrame(TimeFrame);
  IndicatorShortName(timeFrameToString(timeFrame)+" - 2 MA Signals ("+FastMaPeriod+","+SlowMaPeriod );
  return ( 0 );
}


//+------------------------------------------------------------------
//|
//+------------------------------------------------------------------
//
//
//
//
//

int start()
{
   int limit,counted_bars=IndicatorCounted();
   
   if(counted_bars<0) return(-1);
   if(counted_bars>0) counted_bars--;
           limit=MathMin(Bars-counted_bars,Bars-1);
           if (returnBars) { FastMa[0] = limit+1; return(0); }
           if (timeFrame!=Period()) limit = MathMax(limit,MathMin(Bars-1,iCustom(NULL,timeFrame,indicatorFileName,"returnBars",0,0)*timeFrame/Period()));

   //
   //
   //
   //
   //
   
   for(int i=limit; i>=0; i--)
   {
      int y = iBarShift(NULL,timeFrame,Time[i]);
         FastMa[i]  = iMA(NULL,timeFrame,FastMaPeriod,0,FastMaMode,FastMaPrice,y);
         SlowMa[i]  = iMA(NULL,timeFrame,SlowMaPeriod,0,SlowMaMode,SlowMaPrice,y);
         CrossUp[i] = EMPTY_VALUE;
         CrossDn[i] = EMPTY_VALUE;
         trend[i]   = trend[i+1];
            if (FastMa[i]>SlowMa[i]) trend[i] =  1;
            if (FastMa[i]<SlowMa[i]) trend[i] = -1;
            if (trend[i]!=trend[i+1])
               if (trend[i]==1)  CrossUp[i] = SlowMa[i]-iATR(NULL,0,20,i)/2.0;
               else              CrossDn[i] = SlowMa[i]+iATR(NULL,0,20,i)/2.0;
   }
   manageAlerts();
   return(0);
} 


//+-------------------------------------------------------------------
//|                                                                  
//+-------------------------------------------------------------------
//
//
//
//
//

void manageAlerts() 
{
   if (alertsOn) 
   {
      if (alertsOnCurrent)
           int whichBar = 0;
      else     whichBar = 1; whichBar = iBarShift(NULL,0,iTime(NULL,timeFrame,whichBar));
      
      //
      //
      //
      //
      //
      
      if (trend[whichBar] != trend[whichBar+1]) 
      {
         if (trend[whichBar] ==  1) doAlert(whichBar,"up");
         if (trend[whichBar] == -1) doAlert(whichBar,"down");
      }
   }
}

//
//
//
//
//

void doAlert(int forBar, string doWhat) 
{
   static string   previousAlert="nothing";
   static datetime previousTime;
   string message;
   
   if (previousAlert != doWhat || previousTime != Time[forBar]) {
       previousAlert  = doWhat;
       previousTime   = Time[forBar];

       message =  StringConcatenate(Symbol()," ",timeFrameToString(timeFrame)," at ",TimeToStr(TimeLocal(),TIME_SECONDS)," 2 MA crosses trend changed to ",doWhat);
          if (alertsMessage) Alert(message);
          if (alertsEmail)   SendMail(StringConcatenate(Symbol(),"2 MA crosses"),message);
          if (alertsNotify)  SendNotification(message);
          if (alertsSound)   PlaySound("alert2.wav");
   }
}

//+-------------------------------------------------------------------
//|                                                                  
//+-------------------------------------------------------------------
//
//
//
//
//

string sTfTable[] = {"M1","M5","M15","M30","H1","H4","D1","W1","MN"};
int    iTfTable[] = {1,5,15,30,60,240,1440,10080,43200};

//
//
//
//
//

int stringToTimeFrame(string tfs) {
   tfs = stringUpperCase(tfs);
   for (int i=ArraySize(iTfTable)-1; i>=0; i--)
         if (tfs==sTfTable[i] || tfs==""+iTfTable[i]) return(MathMax(iTfTable[i],Period()));
                                                      return(Period());
}
string timeFrameToString(int tf) {
   for (int i=ArraySize(iTfTable)-1; i>=0; i--) 
         if (tf==iTfTable[i]) return(sTfTable[i]);
                              return("");
}

//
//
//
//
//

string stringUpperCase(string str) {
   string   s = str;

   for (int length=StringLen(str)-1; length>=0; length--) {
      int tchar = StringGetChar(s, length);
         if((tchar > 96 && tchar < 123) || (tchar > 223 && tchar < 256))
                     s = StringSetChar(s, length, tchar - 32);
         else if(tchar > -33 && tchar < 0)
                     s = StringSetChar(s, length, tchar + 224);
   }
   return(s);
}
////////////////////////////////EOF//////////////////////////